
#include "main.h"
void SystemClock_Config(void);
static void MX_GPIO_Init(void);

int main(void)
{
	HAL_Init();
	SystemClock_Config();
	MX_GPIO_Init();

	uint8_t B_Shift=0;
	uint8_t B_Digit[3]={0,0,0};
	uint8_t B_Symbols[]={0xfc/*0*/,0x60/*1*/,0xda/*2*/,0xf2/*3*/,0x66/*4*/,0xb6/*5*/,0xbe/*6*/,0xe0/*7*/,0xfe/*8*/,0xf6/*9*/};
	const int _TIME=50;
	uint32_t Counter4time =_TIME;
	uint16_t Counter =0;
	uint16_t W_Word;
	uint8_t B_B;

  while (1)
  {
		// Disable 7-segment digits
		HAL_GPIO_WritePin(DO_Sel1_GPIO_Port, DO_Sel1_Pin, 0);
		HAL_GPIO_WritePin(DO_Sel2_GPIO_Port, DO_Sel2_Pin, 0);
		HAL_GPIO_WritePin(DO_Sel3_GPIO_Port, DO_Sel3_Pin, 0);
		// Update data
		B_B=B_Symbols[B_Digit[B_Shift]];
		HAL_GPIO_WritePin(DO_DOT_GPIO_Port, DO_DOT_Pin,(B_B)&1);
		HAL_GPIO_WritePin(DO_A_GPIO_Port, DO_A_Pin,(B_B>>7)&1);
		HAL_GPIO_WritePin(DO_B_GPIO_Port, DO_B_Pin,(B_B>>6)&1);
		HAL_GPIO_WritePin(DO_C_GPIO_Port, DO_C_Pin,(B_B>>5)&1);
		HAL_GPIO_WritePin(DO_D_GPIO_Port, DO_D_Pin,(B_B>>4)&1);
		HAL_GPIO_WritePin(DO_E_GPIO_Port, DO_E_Pin,(B_B>>3)&1);
		HAL_GPIO_WritePin(DO_F_GPIO_Port, DO_F_Pin,(B_B>>2)&1);
		HAL_GPIO_WritePin(DO_G_GPIO_Port, DO_G_Pin,(B_B>>1)&1);
		// Select digit
		if(B_Shift==0)
		{
			HAL_GPIO_WritePin(DO_Sel1_GPIO_Port, DO_Sel1_Pin, 1);
			B_Shift=1;
		}
		else if(B_Shift==1)
		{
			HAL_GPIO_WritePin(DO_Sel2_GPIO_Port, DO_Sel2_Pin, 1);
			B_Shift=2;
		}
		else if(B_Shift==2)
		{
			HAL_GPIO_WritePin(DO_Sel3_GPIO_Port, DO_Sel3_Pin, 1);
			B_Shift=0;
		}
		HAL_Delay(1);



		if(Counter4time==0)
		{
			Counter4time=_TIME;

			if(Counter==999)
				Counter=0;
			else
				Counter++;

			W_Word=Counter;
			B_Digit[0]=W_Word /100;
			W_Word=W_Word %100;
			B_Digit[1]=W_Word /10;
			W_Word=W_Word %10;
			B_Digit[2]=W_Word;

		}
		else
		{
			Counter4time--;
		}

  }

}


void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.HSEPredivValue = RCC_HSE_PREDIV_DIV1;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLL_MUL9;
  HAL_RCC_OscConfig(&RCC_OscInitStruct);
  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2);
}


static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOD_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOB, DO_F_Pin|DO_E_Pin|DO_D_Pin|DO_C_Pin
                          |DO_Sel3_Pin|DO_Sel1_Pin|DO_Sel2_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOA, DO_B_Pin|DO_A_Pin|DO_G_Pin|DO_DOT_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pins : DO_F_Pin DO_E_Pin DO_D_Pin DO_C_Pin
                           DO_Sel3_Pin DO_Sel1_Pin DO_Sel2_Pin */
  GPIO_InitStruct.Pin = DO_F_Pin|DO_E_Pin|DO_D_Pin|DO_C_Pin
                          |DO_Sel3_Pin|DO_Sel1_Pin|DO_Sel2_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

  /*Configure GPIO pins : DO_B_Pin DO_A_Pin DO_G_Pin DO_DOT_Pin */
  GPIO_InitStruct.Pin = DO_B_Pin|DO_A_Pin|DO_G_Pin|DO_DOT_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);

}

