#include "main.h"
void SystemClock_Config(void);
static void MX_GPIO_Init(void);

int main(void)
{
  HAL_Init();
  SystemClock_Config();
  MX_GPIO_Init();

  while (1)
  {

	  if(HAL_GPIO_ReadPin(DI_SW1_GPIO_Port, DI_SW1_Pin)==0)
	  {
		  HAL_GPIO_TogglePin(DO_R2LED_GPIO_Port, DO_R2LED_Pin);
		  HAL_Delay(200);
	  }
	  else if(HAL_GPIO_ReadPin(DI_SW2_GPIO_Port, DI_SW2_Pin)==0)
	  {
		  HAL_GPIO_TogglePin(DO_GLED_GPIO_Port, DO_GLED_Pin);
		  HAL_Delay(200);
	  }
	  else if(HAL_GPIO_ReadPin(DI_SW3_GPIO_Port, DI_SW3_Pin)==0)
	  {
		  HAL_GPIO_TogglePin(DO_BLED_GPIO_Port, DO_BLED_Pin);
		  HAL_Delay(200);
	  }
	  else if(HAL_GPIO_ReadPin(DI_SW4_GPIO_Port, DI_SW4_Pin)==0)
	  {
		  HAL_GPIO_TogglePin(DO_YLED_GPIO_Port, DO_YLED_Pin);
		  HAL_Delay(200);
	  }
  }
}
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.HSEPredivValue = RCC_HSE_PREDIV_DIV1;
  RCC_OscInitStruct.HSIState = RCC_HSI_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLMUL = RCC_PLL_MUL9;
  HAL_RCC_OscConfig(&RCC_OscInitStruct);

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV2;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;
  HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_2);
}

static void MX_GPIO_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* GPIO Ports Clock Enable */
  __HAL_RCC_GPIOC_CLK_ENABLE();
  __HAL_RCC_GPIOD_CLK_ENABLE();
  __HAL_RCC_GPIOA_CLK_ENABLE();
  __HAL_RCC_GPIOB_CLK_ENABLE();

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(GPIOC, DO_YLED_Pin|DO_BLED_Pin|DO_GLED_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pin Output Level */
  HAL_GPIO_WritePin(DO_R2LED_GPIO_Port, DO_R2LED_Pin, GPIO_PIN_RESET);

  /*Configure GPIO pins : DO_YLED_Pin DO_BLED_Pin DO_GLED_Pin */
  GPIO_InitStruct.Pin = DO_YLED_Pin|DO_BLED_Pin|DO_GLED_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(GPIOC, &GPIO_InitStruct);

  /*Configure GPIO pin : DO_R2LED_Pin */
  GPIO_InitStruct.Pin = DO_R2LED_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_FREQ_LOW;
  HAL_GPIO_Init(DO_R2LED_GPIO_Port, &GPIO_InitStruct);

  /*Configure GPIO pins : DI_SW4_Pin DI_SW3_Pin DI_SW2_Pin DI_SW1_Pin */
  GPIO_InitStruct.Pin = DI_SW4_Pin|DI_SW3_Pin|DI_SW2_Pin|DI_SW1_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  HAL_GPIO_Init(GPIOB, &GPIO_InitStruct);

}

