/*
  Flame_Alarm
 Flame sensor attached to pin 4. 
 Buzzer connect to digital pin 5
 LED(Red) connect to digital pin 6 
 */

// set pin numbers:
const int flamePin = 4; // the number of the flame sensor pin
const int buzzerPin =  5;      // the number of the buzzer pin
const int redPin = 6; //the number of the led pin

// variables will change:
int flameState = 0;         // variable for reading the flame sensor status

void setup() {
  // initialize the buzzer pin as an output:
  pinMode(buzzerPin, OUTPUT);      
  // initialize the flame sensor pin as an input:
  pinMode(flamePin, INPUT);    
  // initialize the led pin as an output:
  pinMode(redPin, OUTPUT);
}

void loop(){
  // read the state of the flame sensor value:
  flameState = digitalRead(flamePin);

  // check if the flame sensor detect a fire.
  // if not, the flameState is HIGH
  // unlike other sensors, flameState is LOW when a fire is detected
  if (flameState == HIGH) {    
    // turn buzzer off:    
    digitalWrite(buzzerPin, LOW);  
    // turn LED off
    digitalWrite(redPin,LOW);
  } 
  else {
    // turn buzzer on:
    digitalWrite(buzzerPin, HIGH); 
    // turn on the LED first, then turn off the LED to make the LED have a flashing alert effect
    digitalWrite(redPin,HIGH);
    delay(500);
    digitalWrite(redPin,LOW);
    delay(500);
  }
}
