/*
  Logic-AND
 sound sensor connect to A0 port
 light sensor connect to A1 port 
 Logic-OR A port connect to D7 port
 Logic-OR B port connect to D8 port
 */

// set pin numbers:
int soundPin = A0; //the number of the sound sensor pin
int lightPin = A1; // the number of the light sensor pin
int LogicA = 7; //the number of the Logic OR A port
int LogicB = 8; //the number of the Logic OR B port


// variables will change:
int soundValue = 0;       //variable for reading the sound sensor value
int lightValue = 0;         // variable for reading the light sensor value

void setup() {
  // initialize the LogicA as an output:
  pinMode(LogicA, OUTPUT);   
  // initialize the LogicB as an output:
  pinMode(LogicB, OUTPUT);      
  // initialize the light sensor pin as an input:
  pinMode(lightPin, INPUT);     
  // initialize the sound pin as an input;
  pinMode(soundPin,INPUT);
}

void loop(){
  // read the Value of the light sensor and sound sensor value:
  lightValue = analogRead(lightPin);
  soundValue = analogRead(soundPin);
  
  // If a loud sound is detected, LogicA is HIGH:
  if (soundValue > 500 && lightValue < 800) {     
    // output HIGH to LogicA:    
    digitalWrite(LogicA, HIGH);  
    digitalWrite(LogicB, HIGH);
  } 
  else {
    // output LOW to LogicA: 
    digitalWrite(LogicA, LOW);
    digitalWrite(LogicB, LOW); 
  }
/*
  //  If darker brightness is detected, LogicB is HIGH:
  if (lightValue < 800) {     
    // output HIGH to LogicB: 
    digitalWrite(LogicA, HIGH);   
    digitalWrite(LogicB, HIGH);  
  } 
  else {
    // output LOW to LogicB: 
    digitalWrite(LogicA, LOW);
    digitalWrite(LogicB, LOW); 
  }
*/

}
