/*
  Switch
 
 Turns on and off a light emitting diode(LED) connected to digital  
 pin 5, when pressing a Switch attached to pin 4. 
 */

// set pin numbers:
int switchPin = 4;     // the number of the Switch pin
int ledPin =  5;      // the number of the LED pin

// variables will change:
int switchState = 0;         // variable for reading the switch status

void setup() {
  // initialize the LED pin as an output:
  pinMode(ledPin, OUTPUT);      
  // initialize the switch pin as an input:
  pinMode(switchPin, INPUT);     
}

void loop(){
  // read the state of the switch value:
  switchState = digitalRead(switchPin);

  // check if the Switch is pressed.
  // if it is, the switchState is HIGH:
  if (switchState == HIGH) {     
    // turn LED on:    
    digitalWrite(ledPin, HIGH);  
  } 
  else {
    // turn LED off:
    digitalWrite(ledPin, LOW); 
  }
}
