#include "TM1650.h" 

int ledPin = 5;
int pmeterPin = A0;
int pmeterValue = 0;

int d,t,h;

TM1650 DigitalLED(A5,A4);

static uint8_t TubeTab[] = {
               0x3F,0x06,0x5B,0x4F,
               0x66,0x6D,0x7D,0x07,
               0x7F,0x6F,0x77,0x7C,
               0x39,0x5E,0x79,0x71,
               };//0~9,A,B,C,D,E,F  
void setup() {
  // put your setup code here, to run once:
  pinMode(ledPin,OUTPUT);
  pinMode(pmeterPin,INPUT);
}

void loop() {
  // put your main code here, to run repeatedly:
 pmeterValue = analogRead(pmeterPin);
 int gapValue = map(pmeterValue,0,1023,0,255); //remap the 0~1023 data to 0~255;
 h = gapValue/100;
 t = gapValue/10%10;
 d = gapValue%10;
 DigitalLED.clearDisplay();
 DigitalLED.display(1,TubeTab[h]);
 DigitalLED.display(2,TubeTab[t]);
 DigitalLED.display(3,TubeTab[d]);
 analogWrite(ledPin, gapValue);   
 delay(2500);// PWM control the lightness of LED
}
