#include "TM1650.h" 

int moisturePin = A0;
int redPin = 2;
int greenPin = 3;
int buzzerPin = 5;

int d,t,h;

int moistureValue = 0;

TM1650 DigitalLED(A5,A4);

static uint8_t TubeTab[] = {
               0x3F,0x06,0x5B,0x4F,
               0x66,0x6D,0x7D,0x07,
               0x7F,0x6F,0x77,0x7C,
               0x39,0x5E,0x79,0x71,
               };//0~9,A,B,C,D,E,F 

void setup() {
  // put your setup code here, to run once:
  pinMode(moisturePin,INPUT);
  pinMode(redPin,OUTPUT);
  pinMode(greenPin,OUTPUT);
  pinMode(buzzerPin,OUTPUT);
  Serial.begin(9600);
}

void loop() {
  // put your main code here, to run repeatedly:
  float moisture = analogRead(moisturePin);
  moistureValue = (moisture*120)/1023;
  delay(20);
  Serial.println(moistureValue);
  
  if(moistureValue<10){
    DigitalLED.clearDisplay();
    DigitalLED.display(3,TubeTab[moistureValue]);
    digitalWrite(greenPin,LOW);
    digitalWrite(redPin,LOW);
    digitalWrite(buzzerPin,HIGH);
    }
  else if((10<=moistureValue)&&(moistureValue<20)){
    DigitalLED.clearDisplay();
    t = moistureValue/10;
    d = moistureValue%10;
    DigitalLED.display(2,TubeTab[t]);
    DigitalLED.display(3,TubeTab[d]);
    digitalWrite(buzzerPin,LOW);
    digitalWrite(greenPin,LOW);
    digitalWrite(redPin,HIGH);
    }
   else{
    DigitalLED.clearDisplay();
    h = moistureValue/100;
    t = moistureValue/10;
    d = moistureValue%10;
    DigitalLED.display(1,TubeTab[h]);
    DigitalLED.display(2,TubeTab[t]);
    DigitalLED.display(3,TubeTab[d]);
    digitalWrite(buzzerPin,LOW);
    digitalWrite(redPin,LOW);
    digitalWrite(greenPin,HIGH);
    }
    delay(1500);
}
