#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>

/* Put your SSID & Password */
const char* ssid = "RM2W-FARESPCB";       
const char* password = ""; 

ESP8266WebServer server(80);

bool O1Status = LOW;
bool O2Status = LOW;

int Output1=5;
int Output2=4;


void setup() {
  Serial.begin(9600);
  pinMode(Output1, OUTPUT); 
  pinMode(Output2, OUTPUT); 

  IPAddress IPaddr (192, 168, 4, 1);
  WiFi.softAP(ssid, password);
  
  IPAddress myIP = WiFi.softAPIP();
  Serial.print("Access Point IP:");
  Serial.println(myIP);
  
  server.on("/", handle_OnConnect);
  server.on("/O1ON", handle_O1ON);
  server.on("/O1OFF", handle_O1OFF);
  server.on("/O2ON", handle_O2ON);
  server.on("/O2OFF", handle_O2OFF);    
  server.onNotFound(handle_NotFound);
  
  server.begin();
  //Serial.println("HTTP Server Started");
}

void loop() {
  server.handleClient();
  
  if(O1Status)
  {digitalWrite(Output1, HIGH);}
  else
  {digitalWrite(Output1, LOW);}
  if(O2Status)
  {digitalWrite(Output2, HIGH);}
  else
  {digitalWrite(Output2, LOW);}
}

void handle_OnConnect() {
  O1Status = LOW;
  O2Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O1ON() {
  O1Status = HIGH; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O1OFF() {
  O1Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O2ON() {
  O2Status = HIGH; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O2OFF() {
  O2Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_NotFound(){
  server.send(404, "text/plain", "Not found");
}

String updateWebpage(){
  String ptr = "<!DOCTYPE html> <html>\n";
  ptr +="<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, user-scalable=no\">\n";
  ptr +="<title>LED Control</title>\n";
  ptr +="<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}\n";
  ptr +="body{margin-top: 50px;} h1 {color: #444444;margin: 50px auto 30px;} h2 {color: #444444;margin-bottom: 50px;}h3 {color: #0000FF;margin: 50px auto 30px;}\n";
  
  ptr +=".button1 {display: block;width: 200px;background-color: #1abc9c;border: none;color: white;padding: 10px 10px;text-decoration: none;font-size: 25px;margin: 0px auto 35px;cursor: pointer;border-radius: 4px;}\n";
  ptr +=".button1-on {background-color: #3498db;}\n";
  ptr +=".button1-on:active {background-color: #3498db;}\n";
  ptr +=".button1-off {background-color: #34495e;}\n";
  ptr +=".button1-off:active {background-color: #2c3e50;}\n";

  ptr +=".button2 {display: block;width: 200px;background-color: #1abc9c;border: none;color: white;padding: 10px 10px;text-decoration: none;font-size: 25px;margin: 0px auto 35px;cursor: pointer;border-radius: 4px;}\n";
  ptr +=".button2-on {background-color: #3498db;}\n";
  ptr +=".button2-on:active {background-color: #3498db;}\n";
  ptr +=".button2-off {background-color: #34495e;}\n";
  ptr +=".button2-off:active {background-color: #2c3e50;}\n";

  
  ptr +="p {font-size: 20px;color: #888;margin-bottom: 10px;}\n";
  ptr +="</style>\n";
  ptr +="</head>\n";
  ptr +="<body>\n";
  ptr +="<h1>FARESPCB</h1>\n";
  ptr +="<h2>2 Channel WiFi Relay Module</h2>\n";
  ptr +="<h3>RM2W</h3>\n";
  if(O1Status){
    ptr +="<p><a class=\"button1 button1-off\" href=\"/O1OFF\">O1 (OFF)</a>\n";
  }else{
    ptr +="<p><a class=\"button1 button1-on\" href=\"/O1ON\">O1 (ON)</a>\n";
  }
  if(O2Status){
    ptr +="<p><a class=\"button2 button2-off\" href=\"/O2OFF\">O2 (OFF)</a>\n";
  }else{
    ptr +="<p><a class=\"button2 button2-on\" href=\"/O2ON\">O2 (ON)</a>\n";
  }
  
  ptr +="</body>\n";
  ptr +="</html>\n";
  return ptr;
}
 
