#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>

/* Put your SSID & Password */
const char* ssid = "RM6W-FARESPCB";       
const char* password = ""; 

ESP8266WebServer server(80);

bool O1Status = LOW;
bool O2Status = LOW;
bool O3Status = LOW;
bool O4Status = LOW;
bool O5Status = LOW;
bool O6Status = LOW;
int Output1=5;
int Output2=4;
int Output3=13;
int Output4=12;
int Output5=14;
int Output6=16;

void setup() {
  Serial.begin(9600);
  pinMode(Output1, OUTPUT); 
  pinMode(Output2, OUTPUT); 
  pinMode(Output3, OUTPUT); 
  pinMode(Output4, OUTPUT); 
  pinMode(Output5, OUTPUT); 
  pinMode(Output6, OUTPUT); 
  IPAddress IPaddr (192, 168, 4, 1);
  WiFi.softAP(ssid, password);
  
  IPAddress myIP = WiFi.softAPIP();
  Serial.print("Access Point IP:");
  Serial.println(myIP);
  
  server.on("/", handle_OnConnect);
  server.on("/O1ON", handle_O1ON);
  server.on("/O1OFF", handle_O1OFF);
  server.on("/O2ON", handle_O2ON);
  server.on("/O2OFF", handle_O2OFF);  
  server.on("/O3ON", handle_O3ON);
  server.on("/O3OFF", handle_O3OFF);
  server.on("/O4ON", handle_O4ON);
  server.on("/O4OFF", handle_O4OFF);   
  server.on("/O5ON", handle_O5ON);
  server.on("/O5OFF", handle_O5OFF);
  server.on("/O6ON", handle_O6ON);
  server.on("/O6OFF", handle_O6OFF);    
  server.onNotFound(handle_NotFound);
  
  server.begin();
  //Serial.println("HTTP Server Started");
}

void loop() {
  server.handleClient();
  
  if(O1Status)
  {digitalWrite(Output1, HIGH);}
  else
  {digitalWrite(Output1, LOW);}
  if(O2Status)
  {digitalWrite(Output2, HIGH);}
  else
  {digitalWrite(Output2, LOW);}
  if(O3Status)
  {digitalWrite(Output3, HIGH);}
  else
  {digitalWrite(Output3, LOW);}
  if(O4Status)
  {digitalWrite(Output4, HIGH);}
  else
  {digitalWrite(Output4, LOW);}
  if(O5Status)
  {digitalWrite(Output5, HIGH);}
  else
  {digitalWrite(Output5, LOW);}
  if(O6Status)
  {digitalWrite(Output6, HIGH);}
  else
  {digitalWrite(Output6, LOW);}
       
    
      
    
}

void handle_OnConnect() {
  O1Status = LOW;
  O2Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O1ON() {
  O1Status = HIGH; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O1OFF() {
  O1Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O2ON() {
  O2Status = HIGH; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O2OFF() {
  O2Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O3ON() {
  O3Status = HIGH; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O3OFF() {
  O3Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O4ON() {
  O4Status = HIGH; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O4OFF() {
  O4Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O5ON() {
  O5Status = HIGH; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O5OFF() {
  O5Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O6ON() {
  O6Status = HIGH; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_O6OFF() {
  O6Status = LOW; 
  server.send(200, "text/html", updateWebpage()); 
}

void handle_NotFound(){
  server.send(404, "text/plain", "Not found");
}

String updateWebpage(){
  String ptr = "<!DOCTYPE html> <html>\n";
  ptr +="<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0, user-scalable=no\">\n";
  ptr +="<title>LED Control</title>\n";
  ptr +="<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}\n";
  ptr +="body{margin-top: 50px;} h1 {color: #444444;margin: 50px auto 30px;} h2 {color: #444444;margin-bottom: 50px;}h3 {color: #0000FF;margin: 50px auto 30px;}\n";
  
  ptr +=".button1 {display: block;width: 200px;background-color: #1abc9c;border: none;color: white;padding: 10px 10px;text-decoration: none;font-size: 25px;margin: 0px auto 35px;cursor: pointer;border-radius: 4px;}\n";
  ptr +=".button1-on {background-color: #3498db;}\n";
  ptr +=".button1-on:active {background-color: #3498db;}\n";
  ptr +=".button1-off {background-color: #34495e;}\n";
  ptr +=".button1-off:active {background-color: #2c3e50;}\n";

  ptr +=".button2 {display: block;width: 200px;background-color: #1abc9c;border: none;color: white;padding: 10px 10px;text-decoration: none;font-size: 25px;margin: 0px auto 35px;cursor: pointer;border-radius: 4px;}\n";
  ptr +=".button2-on {background-color: #3498db;}\n";
  ptr +=".button2-on:active {background-color: #3498db;}\n";
  ptr +=".button2-off {background-color: #34495e;}\n";
  ptr +=".button2-off:active {background-color: #2c3e50;}\n";

  ptr +=".button3 {display: block;width: 200px;background-color: #1abc9c;border: none;color: white;padding: 10px 10px;text-decoration: none;font-size: 25px;margin: 0px auto 35px;cursor: pointer;border-radius: 4px;}\n";
  ptr +=".button3-on {background-color: #3498db;}\n";
  ptr +=".button3-on:active {background-color: #3498db;}\n";
  ptr +=".button3-off {background-color: #34495e;}\n";
  ptr +=".button3-off:active {background-color: #2c3e50;}\n";

  ptr +=".button4 {display: block;width: 200px;background-color: #1abc9c;border: none;color: white;padding: 10px 10px;text-decoration: none;font-size: 25px;margin: 0px auto 35px;cursor: pointer;border-radius: 4px;}\n";
  ptr +=".button4-on {background-color: #3498db;}\n";
  ptr +=".button4-on:active {background-color: #3498db;}\n";
  ptr +=".button4-off {background-color: #34495e;}\n";
  ptr +=".button4-off:active {background-color: #2c3e50;}\n";

  ptr +=".button5 {display: block;width: 200px;background-color: #1abc9c;border: none;color: white;padding: 10px 10px;text-decoration: none;font-size: 25px;margin: 0px auto 35px;cursor: pointer;border-radius: 4px;}\n";
  ptr +=".button5-on {background-color: #3498db;}\n";
  ptr +=".button5-on:active {background-color: #3498db;}\n";
  ptr +=".button5-off {background-color: #34495e;}\n";
  ptr +=".button5-off:active {background-color: #2c3e50;}\n";  

  ptr +=".button6 {display: block;width: 200px;background-color: #1abc9c;border: none;color: white;padding: 10px 10px;text-decoration: none;font-size: 25px;margin: 0px auto 35px;cursor: pointer;border-radius: 4px;}\n";
  ptr +=".button6-on {background-color: #3498db;}\n";
  ptr +=".button6-on:active {background-color: #3498db;}\n";
  ptr +=".button6-off {background-color: #34495e;}\n";
  ptr +=".button6-off:active {background-color: #2c3e50;}\n";

  
  ptr +="p {font-size: 20px;color: #888;margin-bottom: 10px;}\n";
  ptr +="</style>\n";
  ptr +="</head>\n";
  ptr +="<body>\n";
  ptr +="<h1>FARESPCB</h1>\n";
  ptr +="<h2>6 Channel WiFi Relay Module</h2>\n";
  ptr +="<h3>RM6W</h3>\n";
  if(O1Status){
    ptr +="<p><a class=\"button1 button1-off\" href=\"/O1OFF\">O1 (OFF)</a>\n";
  }else{
    ptr +="<p><a class=\"button1 button1-on\" href=\"/O1ON\">O1 (ON)</a>\n";
  }
  if(O2Status){
    ptr +="<p><a class=\"button2 button2-off\" href=\"/O2OFF\">O2 (OFF)</a>\n";
  }else{
    ptr +="<p><a class=\"button2 button2-on\" href=\"/O2ON\">O2 (ON)</a>\n";
  }
  if(O3Status){
    ptr +="<p><a class=\"button3 button3-off\" href=\"/O3OFF\">O3 (OFF)</a>\n";
  }else{
    ptr +="<p><a class=\"button3 button3-on\" href=\"/O3ON\">O3 (ON)</a>\n";
  }
  if(O4Status){
    ptr +="<p><a class=\"button4 button4-off\" href=\"/O4OFF\">O4 (OFF)</a>\n";
  }else{
    ptr +="<p><a class=\"button4 button4-on\" href=\"/O4ON\">O4 (ON)</a>\n";
  }
  if(O5Status){
    ptr +="<p><a class=\"button5 button5-off\" href=\"/O5OFF\">O5 (OFF)</a>\n";
  }else{
    ptr +="<p><a class=\"button5 button5-on\" href=\"/O5ON\">O5 (ON)</a>\n";
  }
  if(O6Status){
    ptr +="<p><a class=\"button6 button6-off\" href=\"/O6OFF\">O6 (OFF)</a>\n";
  }else{
    ptr +="<p><a class=\"button6 button6-on\" href=\"/O6ON\">O6 (ON)</a>\n";
  }  
  
  ptr +="</body>\n";
  ptr +="</html>\n";
  return ptr;
}
 
