/*
OSEPP Sound Sensor Example

OSEPP example of measure sound input from microphone sensor.
depending on loudness, an LED brightness is changed.
Louder sounds = brighter LED. Test with music to get a strobe

*/

int micPin = A0;    // microphone sensor input
int ledPin = 11;      // select the pin for the LED
int micValue = 0;  // variable to store the value coming from the mic sensor

void setup() {
Serial.begin(9600);

}

void loop() {
  // read the value from the sensor:
  micValue = analogRead(micPin);  
micValue = constrain(micValue, 0, 100); //set sound detect clamp 0-100  
  // turn the ledPin on
  int ledbrightness = map(micValue, 0, 100, 0, 255);
  
  Serial.print("incoming value from microphone =");
  Serial.println( micValue);
  analogWrite(ledPin, ledbrightness);  
  delay(100);
           
}
